<?php
require_once 'config.php';
require_once 'functions.php';
requireLogin();

$fileExists = checkDataFile();
$fileDate = getDataFileDate();

// Quick stats from CSV file
$quickStats = [
    'total_records' => 0,
    'unique_engineers' => 0,
    'total_hours' => 0,
    'unique_jobs' => 0
];

if ($fileExists) {
    $data = readCSVData();
    $quickStats['total_records'] = count($data);
    
    $engineers = [];
    $jobs = [];
    $totalHours = 0;
    
    foreach ($data as $row) {
        // Column 16: ENG_NAME, Column 10: WO_NO, Column 24: WORK_TIME
        if (isset($row[16])) $engineers[$row[16]] = true;
        if (isset($row[10])) $jobs[$row[10]] = true;
        if (isset($row[24]) && is_numeric($row[24])) $totalHours += $row[24];
    }
    
    $quickStats['unique_engineers'] = count($engineers);
    $quickStats['total_hours'] = $totalHours;
    $quickStats['unique_jobs'] = count($jobs);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo APP_NAME; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Manrope', sans-serif; background: #f8fafc; color: #1e293b; }
        .container { display: flex; min-height: 100vh; }
        
        .sidebar { width: 260px; background: white; border-right: 1px solid #e2e8f0; padding: 24px 0; position: fixed; height: 100vh; overflow-y: auto; }
        .sidebar-header { padding: 0 24px 24px; border-bottom: 1px solid #e2e8f0; display: flex; align-items: center; gap: 12px; }
        .logo { height: 32px; }
        .app-name { font-size: 20px; font-weight: 700; color: #0066b2; }
        .menu { list-style: none; padding: 16px 0; }
        .menu li { margin-bottom: 4px; }
        .menu a { display: flex; align-items: center; gap: 12px; padding: 12px 24px; color: #64748b; text-decoration: none; font-size: 15px; font-weight: 500; transition: all 0.2s; }
        .menu a:hover, .menu a.active { background: #f1f5f9; color: #0066b2; }
        .menu-icon { width: 20px; height: 20px; display: flex; align-items: center; justify-content: center; }
        
        .main-content { flex: 1; margin-left: 260px; padding: 32px; }
        .topbar { background: white; border-radius: 12px; padding: 16px 24px; margin-bottom: 32px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
        .page-title { font-size: 28px; font-weight: 700; color: #0f172a; }
        .user-info { display: flex; align-items: center; gap: 12px; }
        .user-avatar { width: 40px; height: 40px; background: #0066b2; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 14px; }
        .user-details { text-align: right; }
        .user-name { font-weight: 600; font-size: 14px; color: #0f172a; }
        .user-role { font-size: 12px; color: #64748b; }
        
        .file-info { background: #dbeafe; border-left: 4px solid #2563eb; padding: 16px; border-radius: 8px; margin-bottom: 32px; display: flex; align-items: center; gap: 12px; }
        .file-info.error { background: #fee2e2; border-color: #dc2626; }
        .file-info-icon { font-size: 24px; }
        .file-info-text { flex: 1; }
        .file-info-title { font-weight: 600; color: #0f172a; margin-bottom: 4px; }
        .file-info-desc { font-size: 13px; color: #64748b; }
        
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 24px; margin-bottom: 32px; }
        .stat-card { background: white; border-radius: 12px; padding: 24px; box-shadow: 0 1px 3px rgba(0,0,0,0.05); transition: all 0.3s; }
        .stat-card:hover { box-shadow: 0 4px 12px rgba(0,0,0,0.1); transform: translateY(-2px); }
        .stat-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 16px; }
        .stat-icon { width: 48px; height: 48px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 24px; }
        .stat-icon.blue { background: #dbeafe; color: #2563eb; }
        .stat-icon.green { background: #d1fae5; color: #10b981; }
        .stat-icon.yellow { background: #fef3c7; color: #f59e0b; }
        .stat-icon.purple { background: #e9d5ff; color: #8b5cf6; }
        .stat-value { font-size: 36px; font-weight: 700; color: #0f172a; line-height: 1; margin-bottom: 8px; }
        .stat-label { font-size: 14px; color: #64748b; }
        
        .action-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 16px; margin-bottom: 32px; }
        .action-btn { background: white; border: 2px solid #e2e8f0; border-radius: 12px; padding: 20px; text-decoration: none; display: flex; align-items: center; gap: 16px; transition: all 0.3s; position: relative; }
        .action-btn:hover { border-color: #0066b2; background: #f8fafc; transform: translateY(-2px); }
        .action-icon { width: 48px; height: 48px; border-radius: 10px; background: #0066b2; color: white; display: flex; align-items: center; justify-content: center; font-size: 20px; }
        .action-text { flex: 1; }
        .action-title { font-size: 16px; font-weight: 600; color: #0f172a; margin-bottom: 4px; }
        .action-desc { font-size: 13px; color: #64748b; }
        .help-icon { position: absolute; top: 12px; right: 12px; width: 24px; height: 24px; background: #f1f5f9; color: #64748b; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: 700; cursor: help; transition: all 0.2s; }
        .help-icon:hover { background: #0066b2; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <aside class="sidebar">
            <div class="sidebar-header">
                <img src="<?php echo LOGO_URL; ?>" alt="Logo" class="logo">
                <span class="app-name"><?php echo APP_NAME; ?></span>
            </div>
            <ul class="menu">
                <li><a href="index.php" class="active"><span class="menu-icon">📊</span> Dashboard</a></li>
                <li><a href="analysis/engineer_performance.php"><span class="menu-icon">👤</span> Engineer Performance</a></li>
                <li><a href="analysis/contract_view.php"><span class="menu-icon">📄</span> Contract Analysis</a></li>
                <li><a href="analysis/travel_efficiency.php"><span class="menu-icon">🚗</span> Travel Efficiency</a></li>
                <li><a href="analysis/documentation.php"><span class="menu-icon">📝</span> Documentation</a></li>
                <li><a href="logout.php"><span class="menu-icon">🚪</span> Logout</a></li>
            </ul>
        </aside>
        
        <main class="main-content">
            <div class="topbar">
                <h1 class="page-title">Dashboard</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo strtoupper(substr($_SESSION['full_name'], 0, 2)); ?></div>
                    <div class="user-details">
                        <div class="user-name"><?php echo $_SESSION['full_name']; ?></div>
                        <div class="user-role"><?php echo ucfirst($_SESSION['role']); ?></div>
                    </div>
                </div>
            </div>
            
            <?php if ($fileExists): ?>
            <div class="file-info">
                <div class="file-info-icon">📁</div>
                <div class="file-info-text">
                    <div class="file-info-title">Time Report Loaded</div>
                    <div class="file-info-desc">Last updated: <?php echo $fileDate; ?> | <?php echo number_format($quickStats['total_records']); ?> records</div>
                </div>
            </div>
            <?php else: ?>
            <div class="file-info error">
                <div class="file-info-icon">⚠️</div>
                <div class="file-info-text">
                    <div class="file-info-title">Data File Not Found</div>
                    <div class="file-info-desc">Please upload Time_Report.csv to the /data folder</div>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?php echo number_format($quickStats['total_records']); ?></div>
                            <div class="stat-label">TOTAL RECORDS</div>
                        </div>
                        <div class="stat-icon blue">📋</div>
                    </div>
                    <div class="stat-label">Work entries logged</div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?php echo $quickStats['unique_engineers']; ?></div>
                            <div class="stat-label">ENGINEERS</div>
                        </div>
                        <div class="stat-icon green">👥</div>
                    </div>
                    <div class="stat-label">Active workforce</div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?php echo formatNumber($quickStats['total_hours'], 0); ?></div>
                            <div class="stat-label">WORK HOURS</div>
                        </div>
                        <div class="stat-icon yellow">⏱️</div>
                    </div>
                    <div class="stat-label">Total logged hours</div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?php echo number_format($quickStats['unique_jobs']); ?></div>
                            <div class="stat-label">UNIQUE JOBS</div>
                        </div>
                        <div class="stat-icon purple">🔧</div>
                    </div>
                    <div class="stat-label">Tasks completed</div>
                </div>
            </div>
            
            <div class="action-grid">
                <a href="analysis/engineer_performance.php" class="action-btn" title="Overall engineer-level summary with jobs handled, allocated vs actual hours, overtime analysis">
                    <div class="action-icon">👤</div>
                    <div class="action-text">
                        <div class="action-title">Engineer Performance</div>
                        <div class="action-desc">Overtime & efficiency metrics</div>
                    </div>
                    <div class="help-icon">?</div>
                </a>
                
                <a href="analysis/contract_view.php" class="action-btn" title="Contract-level summary showing job counts, allocated vs worked hours, and exceeded rates">
                    <div class="action-icon">📄</div>
                    <div class="action-text">
                        <div class="action-title">Contract Analysis</div>
                        <div class="action-desc">Customer & contract view</div>
                    </div>
                    <div class="help-icon">?</div>
                </a>
                
                <a href="analysis/travel_efficiency.php" class="action-btn" title="Engineer-level travel vs work hours with travel share percentage">
                    <div class="action-icon">🚗</div>
                    <div class="action-text">
                        <div class="action-title">Travel Efficiency</div>
                        <div class="action-desc">Travel vs work analysis</div>
                    </div>
                    <div class="help-icon">?</div>
                </a>
                
                <a href="analysis/documentation.php" class="action-btn" title="Engineer-level documentation compliance rates showing doc attachment percentages">
                    <div class="action-icon">📝</div>
                    <div class="action-text">
                        <div class="action-title">Documentation</div>
                        <div class="action-desc">Compliance tracking</div>
                    </div>
                    <div class="help-icon">?</div>
                </a>
            </div>
        </main>
    </div>
</body>
</html>
