# ⚡ SUPER SIMPLE SETUP - No Composer Needed!

## 🎉 This Version Requires ZERO Dependencies!

✅ No Composer needed
✅ No special installations
✅ Just upload, configure database, and go!

---

## 📋 5-Minute Setup for cPanel/WHM

### Step 1: Extract Files
1. Log into **cPanel**
2. Go to **File Manager**
3. Navigate to `public_html`
4. Upload `TimeTrack_Simple.zip`
5. Right-click → **Extract**
6. You'll have a folder called `time_report_simple`

### Step 2: Create Database
1. In cPanel, go to **MySQL Databases**
2. Create database: `time_report_db`
3. Create user: `time_user` with a strong password
4. Add user to database with **ALL PRIVILEGES**
5. **Note these 3 things:**
   - Full database name (e.g., `youruser_time_report_db`)
   - Full username (e.g., `youruser_time_user`)  
   - Password

### Step 3: Configure Application
1. In File Manager, open folder `time_report_simple`
2. Right-click `config.php` → **Edit**
3. Find lines 6-9:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'time_report_db');
```

4. Change to YOUR database info:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'youruser_time_user');           // Your user from Step 2
define('DB_PASS', 'your_password_here');           // Your password
define('DB_NAME', 'youruser_time_report_db');      // Your database name
```

5. Click **Save Changes**

### Step 4: Access Application
1. Open browser
2. Go to: `https://yourdomain.com/time_report_simple/`
3. Login with:
   - **Username:** `admin`
   - **Password:** `admin123`

---

## ✅ That's It! No Composer, No Terminal, No Hassle!

Your application is now running!

---

## 🎯 What's Different in This Version?

- Uses **CSV format** instead of Excel (same data, just converted)
- **Pure PHP** - no external libraries needed
- Exactly the same UI and features
- Same 4 analysis modules with charts
- Same beautiful design

---

## 🔒 Important: Change Password!

After first login:
1. cPanel → **phpMyAdmin**
2. Select `youruser_time_report_db` database
3. Click `users` table
4. Edit admin user's password field
5. Select **MD5** from Function dropdown
6. Enter your new password
7. Click **Go**

---

## 🔄 Updating Monthly Data

To upload new month's data:
1. Convert your Excel to CSV (in Excel: File → Save As → CSV)
2. Upload to `time_report_simple/data/`
3. Replace `Time_Report.csv`
4. Done! Refresh your dashboard

---

## 🆘 Troubleshooting

**500 Error?**
- Check database credentials in config.php
- Verify database exists

**Can't login?**
- Check database was created
- Clear browser cookies

**No data showing?**
- Check `data/Time_Report.csv` exists
- File permissions should be 644

---

## 📱 Works On All Devices!

✅ Desktop browsers
✅ Tablets  
✅ Mobile phones

---

## 🎊 Enjoy Your Analytics!

No technical headaches - just upload and use! 🚀
