# Quick Start Guide - TimeTrack Analytics

## ⚡ 5-Minute Setup

### For Local Development (XAMPP/WAMP/MAMP)

1. **Extract Files**
   ```
   Extract the application to:
   - XAMPP: C:\xampp\htdocs\time_report_app\
   - WAMP: C:\wamp64\www\time_report_app\
   - MAMP: /Applications/MAMP/htdocs/time_report_app/
   ```

2. **Install Dependencies**
   ```bash
   cd time_report_app
   composer install
   ```
   
   If composer is not installed:
   ```bash
   php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
   php composer-setup.php
   php composer.phar install
   ```

3. **Setup Database**
   - Open phpMyAdmin (http://localhost/phpmyadmin)
   - Create new database: `time_report_db`
   - No need to import SQL - tables create automatically!

4. **Configure Database**
   Edit `config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_USER', 'root');      // Default for XAMPP/WAMP
   define('DB_PASS', '');          // Empty for XAMPP, 'root' for MAMP
   define('DB_NAME', 'time_report_db');
   ```

5. **Add Excel File**
   - Copy `Time_Report.xlsx` to `data/` folder
   - File is already included!

6. **Access Application**
   ```
   URL: http://localhost/time_report_app/
   Username: admin
   Password: admin123
   ```

---

## 🚀 For Production Server

### Step 1: Upload Files
Upload all files to your server via FTP/cPanel File Manager

### Step 2: SSH into Server
```bash
ssh your_username@your_server.com
cd /path/to/time_report_app
```

### Step 3: Install Dependencies
```bash
composer install --no-dev --optimize-autoloader
```

### Step 4: Create Database
```bash
mysql -u root -p
```
```sql
CREATE DATABASE time_report_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'timetrack_user'@'localhost' IDENTIFIED BY 'secure_password_here';
GRANT ALL PRIVILEGES ON time_report_db.* TO 'timetrack_user'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

### Step 5: Configure Database
Edit `config.php` with your database credentials

### Step 6: Set Permissions
```bash
chmod 755 data/
chmod 644 data/Time_Report.xlsx
chown -R www-data:www-data .
```

### Step 7: Access Application
```
https://yourdomain.com/time_report_app/
```

---

## 🎯 First Time Usage

1. **Login**
   - Username: `admin`
   - Password: `admin123`
   - ⚠️ Change password immediately!

2. **Verify Excel Data**
   - Dashboard shows file info
   - Check record count matches your Excel

3. **Explore Analysis**
   - Click on any analysis card
   - View charts and detailed tables
   - Hover over "?" icons for methodology

4. **Understanding the Data**
   - Each analysis has a blue info box
   - Explains calculation methodology
   - Color-coded badges show status

---

## 📊 Analysis Overview

### 1. Engineer Performance (👤)
**What it shows:** How each engineer performs against allocated time
**Key metrics:** 
- Jobs handled
- Overtime hours
- Efficiency ratios

**Use case:** Identify engineers needing support or training

### 2. Contract Analysis (📄)
**What it shows:** Performance by customer/contract
**Key metrics:**
- Contract hours usage
- Jobs exceeding time
- Exceeded rate %

**Use case:** Identify problematic contracts needing review

### 3. Travel Efficiency (🚗)
**What it shows:** How much time spent traveling vs working
**Key metrics:**
- Travel vs work hours
- Travel share %

**Use case:** Optimize routes and scheduling

### 4. Documentation (📝)
**What it shows:** How well engineers document their work
**Key metrics:**
- Documentation rate
- Undocumented jobs

**Use case:** Improve compliance and record-keeping

---

## 🔧 Common Issues & Fixes

### Issue: "Excel file not found"
**Fix:** 
```bash
cp Time_Report.xlsx data/
chmod 644 data/Time_Report.xlsx
```

### Issue: "Database connection failed"
**Fix:**
1. Check MySQL is running
2. Verify credentials in config.php
3. Ensure database exists

### Issue: "500 Internal Server Error"
**Fix:**
1. Check PHP error log
2. Verify file permissions (644 for files, 755 for directories)
3. Check .htaccess is present

### Issue: "Charts not showing"
**Fix:**
1. Check browser console (F12)
2. Ensure Chart.js CDN is accessible
3. Try different browser

### Issue: "Blank page after login"
**Fix:**
1. Enable PHP errors:
   ```php
   ini_set('display_errors', 1);
   error_reporting(E_ALL);
   ```
2. Check session permissions
3. Verify database tables created

---

## 📱 Mobile Access

The application is fully responsive and works on:
- ✅ Desktop browsers
- ✅ Tablets
- ✅ Mobile phones

---

## 🔄 Updating Excel Data

To update with new monthly data:

1. **Backup current file**
   ```bash
   cp data/Time_Report.xlsx data/Time_Report_backup_$(date +%Y%m%d).xlsx
   ```

2. **Upload new file**
   ```bash
   cp /path/to/new/Time_Report.xlsx data/
   ```

3. **Refresh dashboard**
   - Just reload the page
   - All analysis updates automatically

---

## 💡 Tips for Best Results

1. **Excel Format:** Keep column structure consistent
2. **Data Quality:** Ensure DOC_ATTACHED field is filled
3. **Regular Updates:** Update monthly for accurate trends
4. **Export Data:** Use browser print (Ctrl+P) to save reports
5. **Multiple Users:** Create additional users in database

---

## 🆘 Need Help?

1. Check README.md for detailed documentation
2. Review troubleshooting section
3. Check PHP error logs
4. Verify Excel file format matches specification

---

## 🎉 You're Ready!

The application is now set up and ready to use. Start exploring the analysis modules and gain insights into your team's performance!

**Remember:** Change default password after first login!
